clear all
clc
close all


%% Create Data

load AALabData
Y=Action;
indne=IndNE;
Row=row;
X=FeaturesAct;
featGame=FeaturesMatrix;
Freq=freq;
clear row column


load AANewData
Y=[Y;modal'];
indne=[indne;IndNE];
Row=[Row;row'];
X=[X;FeaturesAct];
featGame=[featGame; FeaturesMatrix];
Freq=[Freq;freq];
clear row column


load AAMTData
m=length(row);
YMT=zeros(1,m);
for i=1:m
    YMT(i)=modal{i}(1); 
end
Row=[Row;row];
X=[X;FeaturesAct];
featGame=[featGame; FeaturesMatrix];
Freq=[Freq;freq];
Y=[Y;YMT'];
indne=[indne;IndNE];


%% Level-1 Prediction

n=length(Y);
lev1=zeros(1,n);
for i=1:n
    sumrow=sum(Row{i},2);
    [~,lev1(i)]=max(sumrow);
end

% Test

K=10;
Error=zeros(1,K);
c = cvpartition(n,'KFold',K);
for k=1:K
    IndTest=find(c.test(k));
    m=length(IndTest);
    rowtest=[];
    ytest=[];
    for i=1:m
        h=IndTest(i);
        rowtest=[rowtest; repmat({Row{h}},[Freq(h,4),1])];
        ytest=[ytest; repmat(1,[Freq(h,1),1]); repmat(2,[Freq(h,2),1]); repmat(3,[Freq(h,3),1])];
    end
    s=length(rowtest);
    error=zeros(1,s);
    for i=1:s
        sumrow=sum(rowtest{i},2);
        [~,lev1(i)]=max(sumrow);
        error(i)=double(logical(lev1(i)~=ytest(i)));
    end
    Error(k)=mean(error);
end

'Level-1'
mean(Error)
sqrt(var(Error))/sqrt(K)


%% Level-1alpha

testalpha=0.01:0.05:2;
q=length(testalpha);

K=10;
c = cvpartition(n,'KFold',K);
Alpha=zeros(1,K);
for k=1:K
    IndTrain=find(c.training(k));
    r=length(IndTrain);
    rowtrain=[];
    ytrain=[];
    for i=1:r
        h=IndTrain(i);
        rowtrain=[rowtrain; repmat({Row{h}},[Freq(h,4),1])];
        ytrain=[ytrain; repmat(1,[Freq(h,1),1]); repmat(2,[Freq(h,2),1]); repmat(3,[Freq(h,3),1])];
    end
    t=length(rowtrain);
    
    Acc=zeros(1,q);
    for j=1:q
        alpha=testalpha(j);
        lev1R=zeros(1,t);
        acc=zeros(1,t);
        for i=1:t
            sumrow=sum(rowtrain{i}.^alpha,2);
            [~,lev1R(i)]=max(sumrow);
            error(i)=double(logical(lev1R(i)~=ytrain(i)));
        end
        Acc(j)=1-mean(error);
    end
    [~,bestalpha(k)]=max(Acc);
    Alpha(k)=testalpha(bestalpha(k));
    
    IndTest=find(c.test(k));
    m=length(IndTest);
    rowtest=[];
    ytest=[];
    for i=1:m
        h=IndTest(i);
        rowtest=[rowtest; repmat({Row{h}},[Freq(h,4),1])];
        ytest=[ytest; repmat(1,[Freq(h,1),1]); repmat(2,[Freq(h,2),1]); repmat(3,[Freq(h,3),1])];
    end
    s=length(rowtest);
    for i=1:s
        sumrow=sum(rowtest{i}.^Alpha(k),2);
        [~,lev1(i)]=max(sumrow);
        error(i)=double(logical(lev1(i)~=ytest(i)));
    end
    Error(k)=mean(error);
end

'Level-1(alpha)'
mean(Error)
sqrt(var(Error))/sqrt(K)

%% Decision Tree

K=10;
c = cvpartition(n,'KFold',K);
Accuracy=zeros(1,15);
Error=zeros(15,K);

for k=1:K
    IndTrain=find(c.training(k));
    r=length(IndTrain);
    Xtrain=[];
    ytrain=[];
    for i=1:r
        h=IndTrain(i);
        Xtrain=[Xtrain; repmat(X(h,:),[Freq(h,4),1])];
        ytrain=[ytrain; repmat(1,[Freq(h,1),1]); repmat(2,[Freq(h,2),1]); repmat(3,[Freq(h,3),1])];
    end    
    
    IndTest=find(c.test(k));
    m=length(IndTest);
    Xtest=[];
    ytest=[];
    for i=1:m
        h=IndTest(i);
        Xtest=[Xtest; repmat(X(h,:),[Freq(h,4),1])];
        ytest=[ytest; repmat(1,[Freq(h,1),1]); repmat(2,[Freq(h,2),1]); repmat(3,[Freq(h,3),1])];
    end
    s=length(ytest);
    
    for u=1:15
        tree=fitctree(Xtrain,ytrain,'MaxNumSplits',u,'PredictorNames',DescriptionAct);
        predtree=predict(tree,Xtest);
        error=zeros(1,s);
        for i=1:s
            error(i)=double(logical(predtree(i)~=ytest(i)));
        end
        Error(u,k)=mean(error);
        Accuracy(u)=1-mean(Error(u,:));
        clear error
    end
end

[~,best]=max(Accuracy);

'Decision Tree'
Accuracy(best)
sqrt(var(Error(best,:)))/sqrt(K)

%% PDNE

clear Error error

ind=[3,15,27];
FeatParetoNE=X(:,ind);

K=10;
c = cvpartition(n,'KFold',K);
for k=1:K
    IndTest=find(c.test(k));
    m=length(IndTest);
    pdnetest=[];
    ytest=[];
    for i=1:m
        h=IndTest(i);
        pdnetest=[pdnetest; repmat(FeatParetoNE(h,:),[Freq(h,4),1])];
        ytest=[ytest; repmat(1,[Freq(h,1),1]); repmat(2,[Freq(h,2),1]); repmat(3,[Freq(h,3),1])];
    end
    s=length(ytest);
    predpdne=zeros(s,1);
    for i=1:s
        if sum(pdnetest(i,:))>0
            [~,predpdne(i)]=find(pdnetest(i,:));
        else
            predpdne(i)=randi(3);
        end
        error(i)=double(logical(predpdne(i)~=ytest(i)));
    end
    Error(k)=mean(error);
    clear error
end

'PDNE'
mean(Error)
sqrt(var(Error))/sqrt(K)


%% Lev 1 + PDNE

K=10;
c = cvpartition(n,'KFold',K);
AccTest=zeros(1,K);
for k=1:K
    IndTrain=find(c.training(k));
    r=length(IndTrain);
    feattrain=[];
    Xtrain=[];
    ytrain=[];
    pdnetrain=[];
    rowtrain=[];
    for i=1:r
        h=IndTrain(i);
        feattrain=[feattrain; repmat(featGame(h,:),[Freq(h,4),1])];
        Xtrain=[Xtrain; repmat(X(h,:),[Freq(h,4),1])];
        ytrain=[ytrain; repmat(1,[Freq(h,1),1]); repmat(2,[Freq(h,2),1]); repmat(3,[Freq(h,3),1])];
        pdnetrain=[pdnetrain; repmat(FeatParetoNE(h,:),[Freq(h,4),1])];
        rowtrain=[rowtrain; repmat({Row{h}},[Freq(h,4),1])];
    end   
    
    % Train level-1alpha
    t=length(rowtrain);
    
    Acc=zeros(1,q);
    for j=1:q
        alpha=testalpha(j);
        lev1R=zeros(1,t);
        acc=zeros(1,t);
        error=zeros(1,t);
        for i=1:t
            sumrow=sum(rowtrain{i}.^alpha,2);
            [~,lev1R(i)]=max(sumrow);
            error(i)=double(logical(lev1R(i)~=ytrain(i)));
        end
        Acc(j)=1-mean(error);
    end
    [~,bestalpha(k)]=max(Acc);
    Alpha(k)=testalpha(bestalpha(k));
    
    errorlev1=zeros(t,1);
    lev1tr=zeros(t,1);
    for i=1:t
        sumrow=sum(rowtrain{i}.^Alpha(k),2);
        [~,lev1tr(i)]=max(sumrow);
        errorlev1(i)=double(logical(lev1tr(i)~=ytrain(i)));
    end
    
    % PDNE
    errorpdne=zeros(t,1);
    for i=1:t
        if sum(pdnetrain(i,:))>0
            [~,predpdnetr(i)]=find(pdnetrain(i,:));
        else
            predpdnetr(i)=randi(3);
        end
        errorpdne(i)=double(logical(predpdnetr(i)~=ytrain(i)));
    end
    
    % Learn trees
    
    treelev1=fitrtree(feattrain,errorlev1,'MaxNumSplits',2,'PredictorNames',DescriptionMatrix);
    treepdne=fitrtree(feattrain,errorpdne,'MaxNumSplits',2,'PredictorNames',DescriptionMatrix);
    
    IndTest=find(c.test(k));
    m=length(IndTest);
    Xtest=[];
    ytest=[];
    feattest=[];
    pdnetest=[];
    rowtest=[];
    for i=1:m
        h=IndTest(i);
        pdnetest=[pdnetest; repmat(FeatParetoNE(h,:),[Freq(h,4),1])];
        feattest=[feattest; repmat(featGame(h,:),[Freq(h,4),1])];
        Xtest=[Xtest; repmat(X(h,:),[Freq(h,4),1])];
        ytest=[ytest; repmat(1,[Freq(h,1),1]); repmat(2,[Freq(h,2),1]); repmat(3,[Freq(h,3),1])];
        rowtest=[rowtest; repmat({Row{h}},[Freq(h,4),1])];
    end
    
    predicterrlev1=predict(treelev1,feattest);
    predicterrpdne=predict(treepdne,feattest);
    clear lev1
    
    s=length(ytest);
    for i=1:s
        if predicterrlev1(i)<=predicterrpdne(i)
             	sumrow=sum(rowtest{i}.^Alpha(k),2);
                [~,lev1(i)]=max(sumrow);
                errortest(i)=double(logical(lev1(i)~=ytest(i)));
        else
            if sum(pdnetest(i,:))>0
                predpnetest=find(pdnetest(i,:));
                errortest(i)=double(logical(predpnetest~=ytest(i)));
            else
                predpnetest=randi(3);
                errortest(i)=double(logical(predpnetest~=ytest(i)));
            end
        end
    end
    AccTest(k)=1-mean(errortest);
end

'Hybrid'
mean(AccTest)
sqrt(var(AccTest))/sqrt(K)

%% Ideal

z=length(Row);
truemode=zeros(1,z);
for i=1:z
    [~,truemode(i)]=max(Freq(i,1:3));
end

clear Error error
K=10;
Error=zeros(1,K);
c = cvpartition(n,'KFold',K);
for k=1:K
    IndTest=find(c.test(k));
    m=length(IndTest);
    modetest=[];
    ytest=[];
    for i=1:m
        h=IndTest(i);
        modetest=[modetest; repmat(truemode(h),[Freq(h,4),1])];
        ytest=[ytest; repmat(1,[Freq(h,1),1]); repmat(2,[Freq(h,2),1]); repmat(3,[Freq(h,3),1])];
    end
    s=length(ytest);
 
    error=zeros(1,s);
    for i=1:s
        error(i)=double(logical(modetest(i)~=ytest(i)));
    end
    Error(k)=mean(error);
    clear error
end

'Ideal'
1-mean(Error)
sqrt(var(Error))/sqrt(K)


